    // Function to create random blobs
    function createRandomBlob() {
      const blob = document.createElement('div');
      blob.classList.add('blob');

      // Random size for the blob (between 100px and 300px)
      const size = Math.random() * 200 + 100;
      blob.style.width = `${size}px`;
      blob.style.height = `${size}px`;

      // Random initial position
      const randomX = Math.random() * 100;
      const randomY = Math.random() * 100;
      blob.style.left = `${randomX}%`;
      blob.style.top = `${randomY}%`;

      // Random animation duration (between 8s and 15s)
      const duration = Math.random() * 7 + 8;
      blob.style.animationDuration = `${duration}s`;

      // Random blur effect (higher values for stronger blur)
      const blurAmount = Math.random() * 30 + 10; // Increased blur range (10px - 40px)
      blob.style.filter = `blur(${blurAmount}px)`;

      // Fade-in effect when blob appears
      setTimeout(() => {
        blob.style.opacity = 1;
      }, 100);

      // Add blob to container
      document.getElementById('blobs-container').appendChild(blob);

      // Randomly remove and replace blobs every 5-10 seconds
      setTimeout(() => {
        removeBlob(blob);
      }, Math.random() * 5000 + 5000);
    }

    // Function to remove blob with fade-out effect
    function removeBlob(blob) {
      blob.style.opacity = 0; // Fade out
      setTimeout(() => {
        blob.remove(); // Remove blob after fade-out
        createRandomBlob(); // Create new blob
      }, 1000); // Wait for 1s for fade-out before removal
    }

    // Create a random number of blobs initially
    function createBlobs() {
      const numberOfBlobs = 5; // Adjust the number of blobs here
      for (let i = 0; i < numberOfBlobs; i++) {
        createRandomBlob();
      }
    }

    // Call the function to create blobs on page load
    window.onload = createBlobs;